<?php
// Habilitar la visualización de errores PHP para depuración.
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

// --- SOLUCIÓN DE ZONA HORARIA ---
date_default_timezone_set('America/Guatemala'); // Mantén esta si es tu zona correcta

// --- CAMBIO REALIZADO: SE ACTIVÓ LA CONEXIÓN REAL A LA BASE DE DATOS ---
// Incluir el conector a la base de datos
include 'ConectAPI.php'; // Esta línea ahora está activa.

// Define el nombre del archivo de contenido.
$archivo_contenido = 'dashboardKLSMPN3721.php'; // Asegúrate de que este archivo exista en la misma carpeta

$error_mensaje = '';

// --- LÓGICA DE LOGIN ---
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // El código ahora usará la variable $conn de tu archivo 'ConectAPI.php'
    $email_ingresado = $_POST['email'];
    $password_ingresada = $_POST['password'];
    
    // Usamos sentencias preparadas para máxima seguridad
    $stmt = $conn->prepare("SELECT id, nombre, password, fecha_expiracion FROM estudiantes WHERE email = ?");
    
    if ($stmt === false) {
        $error_mensaje = 'Error al preparar la consulta SQL: ' . htmlspecialchars($conn->error);
    } else {
        $stmt->bind_param("s", $email_ingresado);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows === 1) {
            $usuario = $result->fetch_assoc();
            
            // Verificar si la contraseña es correcta
            if (password_verify($password_ingresada, $usuario['password'])) {
                
                // --- LÓGICA DE FECHA DE EXPIRACIÓN ---
                $fecha_exp = new DateTime($usuario['fecha_expiracion']);
                $fecha_exp->setTime(23, 59, 59); // El acceso es válido durante todo el día de expiración.
                $hoy = new DateTime();

                // Verificar si la cuenta no ha expirado
                if ($fecha_exp >= $hoy) {
                    $_SESSION['loggedin'] = true;
                    $_SESSION['user_id'] = $usuario['id'];
                    $_SESSION['user_name'] = $usuario['nombre'];
                    
                    // Se eliminó la redirección para que el dashboard se cargue en esta misma página.
                } else {
                    $error_mensaje = 'Tu acceso ha expirado. Por favor, contacta al soporte para renovar.';
                }
            } else {
                $error_mensaje = 'El email o la contraseña son incorrectos.';
            }
        } else {
            $error_mensaje = 'El email o la contraseña son incorrectos.';
        }
        $stmt->close();
    }
}

// Lógica para cerrar sesión.
if (isset($_GET['logout'])) {
    session_unset();
    session_destroy();
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CLIENT3 | Acceso Al Centro De Herramientas Inteligentes</title>
            <?php include 'gtm-header.php'; ?>

    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style> body { font-family: 'Barlow', sans-serif; } </style>
</head>
<!-- CAMBIO REALIZADO: El color de fondo ahora es condicional. Será claro si el usuario está logueado, y azul oscuro si no. -->
<body class="<?php echo (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] == true) ? 'bg-[#f5f5f5]' : 'bg-[#07162d]'; ?>">

    <?php if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] == true): ?>
        
        <!-- Esta sección se muestra si el usuario ha iniciado sesión correctamente -->
        <div class="w-full">
            <div class="max-w-7xl mx-auto">
                <?php 
                // Se incluye el archivo del dashboard directamente aquí
                if (file_exists($archivo_contenido)) {
                    include $archivo_contenido; 
                } else {
                    // Este mensaje de error se mostrará si el archivo del dashboard no se encuentra
                    echo '<div class="bg-red-100 text-red-700 p-4 rounded-lg text-center"><strong>Error:</strong> No se pudo cargar el dashboard. El archivo ' . htmlspecialchars($archivo_contenido) . ' no fue encontrado.</div>';
                }
                ?>
            </div>
        </div>

    <?php else: ?>
        
        <!-- Esta sección muestra el formulario de login si el usuario no ha iniciado sesión -->
        <div class="container mx-auto p-4 flex min-h-screen items-center justify-center">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-0 max-w-5xl rounded-2xl shadow-2xl overflow-hidden">
                <div class="hidden md:block">
                    <img src="Portada.jpg" alt="Portada Recurso" class="w-full h-full object-cover">
                </div>
                <div class="bg-white p-8 md:p-12 flex flex-col justify-center">
                    <header class="text-center mb-6">
                    <img src="LogoPlataformaNegro.png" alt="Logo Recurso" class="mx-auto h-20 w-auto mb-4">
                        <h1 class="text-3xl font-black">
                            <span class="text-[#07162d]">ACCESO</span> <span class="text-[#9e1428]">ESTUDIANTES</span>
                        </h1>
                        <p class="text-gray-600 mt-2">Ingresa tus credenciales para acceder.</p>
                    </header>
                    
                    <form method="post" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" class="space-y-6">
                        <div>
                            <div class="relative"><span class="absolute inset-y-0 left-0 flex items-center pl-3"><i class="fas fa-envelope text-gray-400"></i></span><input type="email" id="email" name="email" class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-[#ffc857] focus:border-[#ffc857]" placeholder="Tu Correo Electrónico" required></div>
                        </div>
                        <div>
                            <div class="relative"><span class="absolute inset-y-0 left-0 flex items-center pl-3"><i class="fas fa-lock text-gray-400"></i></span><input type="password" id="password" name="password" class="w-full pl-10 pr-10 py-3 border border-gray-300 rounded-lg focus:ring-[#ffc857] focus:border-[#ffc857]" placeholder="Contraseña" required><span class="absolute inset-y-0 right-0 flex items-center pr-3 cursor-pointer" id="togglePassword"><i class="fas fa-eye text-gray-400" id="eyeIcon"></i></span></div>
                        </div>

                        <?php if (!empty($error_mensaje)): ?>
                            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg relative text-center" role="alert"><span><?php echo $error_mensaje; ?></span></div>
                        <?php endif; ?>

                        <button type="submit" class="w-full bg-[#07162d] text-white font-bold py-3 px-8 rounded-lg hover:bg-opacity-90 transition-opacity shadow-lg text-lg">ACCEDER AL PORTAL</button>
                    </form>
                
    <!-- Reemplazo del footer con el include de PHP -->
    <?php include 'FooterBK.php'; ?>
                </div>
            </div>
        </div>

    <?php endif; ?>

    <script>
        const togglePassword = document.querySelector('#togglePassword');
        if (togglePassword) {
            const passwordInput = document.querySelector('#password');
            const eyeIcon = document.querySelector('#eyeIcon');
            togglePassword.addEventListener('click', function () {
                const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
                passwordInput.setAttribute('type', type);
                eyeIcon.classList.toggle('fa-eye');
                eyeIcon.classList.toggle('fa-eye-slash');
            });
        }
    </script>
</body>
</html>
