<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>¡Registro Completado! - Academia De Publicidad</title>
    <?php include 'gtm-header.php'; ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        :root {
            --color-primary: #07162d;   /* Azul Oscuro */
            --color-secondary: #9e1428; /* Rojo */
            --color-highlight: #ffc857; /* Amarillo */
            --color-white: #ffffff;
            --color-text: #3d3d3d;
        }
        body {
            font-family: 'Barlow', sans-serif;
            background-color: var(--color-primary);
            margin: 0;
            padding: 2rem 1rem;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
    </style>
</head>
<body>
    <div class="container mx-auto p-4 flex min-h-screen items-center justify-center">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-0 max-w-5xl w-full rounded-2xl shadow-2xl overflow-hidden">
            
            <!-- Columna de la imagen -->
            <div class="hidden md:block">
                 <img src="Portada.jpg" alt="Portada Recurso" class="w-full h-full object-cover">
            </div>
            
            <!-- Columna del contenido de confirmación -->
            <div class="bg-white p-8 md:p-12 flex flex-col justify-center text-center">
                <header>
                    <img src="LogoPlataformaNegro.png" alt="Logo Plataforma" class="mx-auto h-20 w-auto mb-6">
                    <h1 class="text-4xl font-black leading-tight">
                        <span class="text-[var(--color-primary)]">¡REGISTRO COMPLETADO</span><br>
                        <span class="text-[var(--color-secondary)]">CON ÉXITO!</span>
                    </h1>
                </header>
                
                <main class="my-6">
                    <p class="text-gray-700 text-lg">
                        Gracias por unirte a nuestra plataforma. Tu acceso ha sido activado y ya puedes iniciar sesión para acceder a todo el contenido.
                    </p>
                </main>

                <a href="index.php" class="w-full max-w-xs mx-auto bg-[var(--color-secondary)] text-white font-bold py-3 px-6 rounded-lg hover:bg-opacity-90 transition-opacity shadow-lg text-lg no-underline">
                    ACCEDER AL PORTAL
                </a>

                <!-- Pie de Página -->
                <footer class="mt-8">
                    <?php include 'FooterBK.php'; ?>
                </footer>
            </div>
        </div>
    </div>
</body>
</html>
