<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CLIENT3 | Generador De Hooks Para Anuncios - Academia De Publicidad</title>
    <?php include 'gtm-header.php'; ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        body { 
            font-family: 'Barlow', sans-serif; 
        }
        #result-container { opacity: 0; transform: scale(0.95); animation: fade-in 0.5s ease-out forwards; }
        @keyframes fade-in { to { opacity: 1; transform: scale(1); } }
        .loader { border: 4px solid #f3f3f3; border-top: 4px solid #07162d; border-radius: 50%; width: 24px; height: 24px; animation: spin 1s linear infinite; }
        @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
    </style>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: { sans: ['Barlow', 'sans-serif'], },
                    colors: { 
                        'brand-blue-dark': '#07162d', 
                        'brand-red': '#9e1428',
                        'brand-white': '#f5f5f5',
                        'brand-yellow': '#ffc857'
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-brand-white">
    <div class="container mx-auto p-4 md:p-8 max-w-4xl">
        
        <div class="text-center mb-6">
            <img src="LogoClient3Black.png" alt="Logo CLIENT3" class="mx-auto h-24 w-auto">
        </div>

        <header class="text-center mb-8">
            <h1 class="text-4xl font-black text-brand-blue-dark">GENERADOR DE TÍTULOS PARA IMÁGENES</h1>
            <p class="text-gray-600 mt-2 text-xl">Crea Títulos Y Textos Cortos Y Potentes Para Tus Imágenes De Post</p>
        </header>

        <div class="bg-white p-6 md:p-8 rounded-2xl shadow-lg">
            <form id="hook-form" class="space-y-6">
                <div>
                    <label for="service" class="block text-lg font-semibold text-brand-blue-dark mb-2">1. ¿Qué Servicio Ofreces?</label>
                    <input type="text" id="service" placeholder="Ej: Servicios De Contabilidad" class="w-full p-3 border border-gray-300 rounded-md" required>
                </div>
                <div>
                    <label for="ideal_client_summary" class="block text-lg font-semibold text-brand-blue-dark mb-2">2. Pega El Resumen De Tu Cliente Ideal</label>
                    <textarea id="ideal_client_summary" placeholder="Pega aquí el resumen que generaste con la Herramienta 1..." class="w-full p-3 border border-gray-300 rounded-md" rows="6" required></textarea>
                </div>
                
                <button id="generateBtn" type="submit" class="w-full bg-brand-red text-white font-bold py-3 px-4 rounded-lg hover:opacity-90 transition-opacity shadow-lg text-lg flex items-center justify-center">
                    <span id="btn-text">Generar Hooks Para Imagenes</span>
                    <div id="loader" class="loader hidden ml-3"></div>
                </button>
            </form>
        </div>
        
        <div id="result-container" class="mt-8"></div>
    </div>
            <div class="text-center mt-8 mb-8">
        <a href="index.php" class="text-brand-blue-dark text-xl md:text-2xl font-extrabold flex items-center justify-center">
            <i class="fas fa-arrow-left mr-2"></i> REGRESAR AL PORTAL
        </a>
    </div>
    
  <?php include 'FooterBK.php'; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('hook-form');
    const resultContainer = document.getElementById('result-container');
    
    form.addEventListener('submit', async function(event) {
        event.preventDefault();
        const generateBtn = document.getElementById('generateBtn');
        const btnText = document.getElementById('btn-text');
        const loader = document.getElementById('loader');

        btnText.textContent = 'Generando Ideas De Títulos...';
        loader.classList.remove('hidden');
        generateBtn.disabled = true;
        resultContainer.innerHTML = '';
        
        const payload = {
            service: document.getElementById('service').value,
            ideal_client_summary: document.getElementById('ideal_client_summary').value,
        };

        try {
            const response = await fetch('API-Generador-De-Titulos-Para-Imagenes.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(payload)
            });

            if (!response.ok) { throw new Error('Error en la respuesta del servidor.'); }

            const data = await response.json();
            displayResult(data);

        } catch (error) {
            console.error("Error:", error);
            resultContainer.innerHTML = `<div class="text-center p-4 bg-red-100 text-red-700 rounded-lg"><p><strong>Error:</strong> No se pudieron generar los hooks.</p></div>`;
        } finally {
            btnText.textContent = 'Generar Hooks';
            loader.classList.add('hidden');
            generateBtn.disabled = false;
        }
    });

    function displayResult(data) {
        const resultContainer = document.getElementById('result-container');
        resultContainer.style.opacity = '0';
        resultContainer.innerHTML = `
            <div class="bg-white p-8 rounded-2xl shadow-lg border-t-8 border-brand-red space-y-8">
                <div>
                    <h2 class="text-3xl font-black text-brand-blue-dark"><i class="fas fa-exclamation-circle text-brand-red mr-2"></i>Hooks Enfocados En El Problema</h2>
                    ${createHookSection(data.problem_hooks)}
                </div>

                <div class="border-t pt-8">
                    <h2 class="text-3xl font-black text-brand-blue-dark"><i class="fas fa-star text-brand-yellow mr-2"></i>Hooks Enfocados En La Transformación</h2>
                    ${createHookSection(data.result_hooks)}
                </div>

                 <div class="border-t pt-8">
                    <h2 class="text-3xl font-black text-brand-blue-dark"><i class="fas fa-image text-brand-red mr-2"></i>IDEAS PARA LA IMAGEN</h2>
                    <ul class="list-disc list-inside text-gray-700 mt-4 pl-4 space-y-2 text-lg">
                        ${data.image_ideas.map(idea => `<li>${idea}</li>`).join('')}
                    </ul>
                </div>
            </div>
        `;
        
        setTimeout(() => { 
            resultContainer.style.opacity = '1'; 
            resultContainer.scrollIntoView({ behavior: 'smooth' });
        }, 100);
    }

    function createHookSection(hooks) {
        let html = '<div class="mt-4 grid grid-cols-1 md:grid-cols-3 gap-4">';
        hooks.forEach(hook => {
            html += `
                <div class="bg-gray-50 p-4 rounded-lg">
                    <p class="font-semibold text-brand-blue-dark">🇪🇸 ${hook.es}</p>
                    <p class="font-semibold text-gray-600 mt-2">🇺🇸 ${hook.en}</p>
                </div>
            `;
        });
        html += '</div>';
        return html;
    }
});
</script>
</body>
</html>
