<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CheckList | Publicidad En 3 Pasos - CLIENT3</title>
    <?php include 'gtm-header.php'; ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        body { 
            font-family: 'Barlow', sans-serif; 
        }
    </style>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: { sans: ['Barlow', 'sans-serif'], },
                    colors: { 
                        'brand-blue-dark': '#07162d', 
                        'brand-red': '#9e1428',
                        'brand-white': '#f5f5f5',
                        'brand-yellow': '#ffc857'
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-brand-white">
    <div class="container mx-auto p-4 md:p-8 max-w-4xl flex flex-col min-h-screen">
        
        <div class="text-center mb-6">
            <img src="LogoClient3Black.png" alt="Logo CLIENT3" class="mx-auto h-24 w-auto">
        </div>

        <main class="flex-grow flex items-center">
            <div class="w-full">
                <header class="text-center mb-8">
                    <h1 class="text-5xl font-black text-brand-blue-dark">DESCARGA TU CHECKLIST</h1>
                    <p class="text-gray-600 mt-2 text-xl">La Guía Rápida Para Lanzar Tu Publicidad En 3 Pasos</p>
                </header>

                <div class="bg-white p-6 md:p-8 rounded-2xl shadow-lg max-w-4xl mx-auto">
                   <div class="grid md:grid-cols-2 gap-8 items-center">
                        <div class="text-center md:text-left">
                            <p class="text-gray-700 text-lg">
                                Este resumen te permite ver de forma clara y rápida qué pasos ya completaste y qué te falta. Úsalo al final de cada módulo para revisar tu avance y asegurarte de que estás construyendo una campaña sólida.
                            </p>
                            <a href="URL_DEL_CHECKLIST_AQUI" target="_blank" class="mt-8 inline-block w-full sm:w-auto bg-brand-red text-white font-bold py-3 px-8 rounded-lg hover:opacity-90 transition-opacity shadow-lg text-lg">
                                <i class="fas fa-download mr-2"></i>Descargar Checklist
                            </a>
                        </div>
                       <div class="text-center">
                            <img src="checklist.jpg" alt="Mockup del Checklist" class="mx-auto rounded-lg shadow-xl w-full max-w-xs">
                        </div>
                   </div>
                </div>

                       <div class="text-center mt-8 mb-8">
        <a href="index.php" class="text-brand-blue-dark text-xl md:text-2xl font-extrabold flex items-center justify-center">
            <i class="fas fa-arrow-left mr-2"></i> REGRESAR AL PORTAL
        </a>
    </div>
            </div>
        </main>
        
   <?php include 'FooterBK.php'; ?>
    </div>
</body>
</html>
