<?php
header('Content-Type: application/json');

$apiKey = 'AIzaSyBohJvh2smaa0zW8VdyGpXpJEg269fJXJw'; // TU API KEY

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido.']);
    exit;
}

$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

if (!$data || !isset($data['service']) || !isset($data['ideal_client_summary'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Faltan datos en la solicitud.']);
    exit;
}

// --- PROMPT MAESTRO (v1.0 - GENERADOR DE HOOKS) ---
$prompt = "Actúa como un copywriter publicitario experto en crear 'hooks' (ganchos) potentes y cortos para anuncios en redes sociales.

--- FILOSOFÍA ---
Los hooks para imágenes o videos deben ser extremadamente cortos y directos para captar la atención en menos de 2 segundos. Deben atacar un problema o evocar una transformación.

--- TU TAREA ESPECÍFICA ---
Un dueño de negocio necesita títulos para las imágenes/videos de sus anuncios. Analiza la información que te proporciona y genera lo siguiente:

--- DATOS DEL NEGOCIO ---
- Servicio que Ofrece: {$data['service']}
- Resumen del Cliente Ideal (su problema y deseo): {$data['ideal_client_summary']}

--- FORMATO DE RESPUESTA REQUERIDO ---
Genera un objeto JSON válido con la siguiente estructura y claves exactas:
- 'problem_hooks': Un array de 3 objetos. Cada objeto debe tener una clave 'es' y 'en' con un hook ENFOCADO EN EL PROBLEMA.
- 'result_hooks': Un array de 3 objetos. Cada objeto debe tener una clave 'es' y 'en' con un hook ENFOCADO EN LA TRANSFORMACIÓN O RESULTADO.
- 'image_ideas': Un array de 2 o 3 strings. Cada string es una idea creativa para la imagen del anuncio, descrita en español.

--- REGLAS ESTRICTAS ---
- **TODOS los hooks (tanto 'es' como 'en') DEBEN tener un máximo de 50 caracteres.** Esta regla es innegociable.
- Los hooks deben ser ganchos, no frases completas. Son para poner sobre una imagen.
- Las 'image_ideas' deben estar en español.";

$apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . $apiKey;
$payload = ['contents' => [['parts' => [['text' => $prompt]]]], 'generationConfig' => ['response_mime_type' => 'application/json']];

$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($response === false || $http_code !== 200) {
    http_response_code(500);
    echo json_encode(['error' => 'No se pudo obtener una respuesta de la IA.']);
    exit;
}

$result = json_decode($response, true);
$generated_text = $result['candidates'][0]['content']['parts'][0]['text'];
$generated_text = str_replace(['```json', '```'], '', $generated_text);
$final_data = json_decode(trim($generated_text), true);

if ($final_data === null || !isset($final_data['problem_hooks'])) {
    http_response_code(500);
    echo json_encode(['error' => 'La IA devolvió un formato de JSON inválido.', 'raw_response' => $generated_text]);
    exit;
}

echo json_encode($final_data);
?>