<?php
header('Content-Type: application/json');

$apiKey = 'AIzaSyBohJvh2smaa0zW8VdyGpXpJEg269fJXJw'; // TU API KEY YA ESTÁ AQUÍ

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido.']);
    exit;
}

$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

if (!$data || !isset($data['service']) || !isset($data['problem']) || !isset($data['desire']) || !isset($data['zone']) || !isset($data['business_name']) || !isset($data['phone'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Faltan datos en la solicitud.']);
    exit;
}

// --- PROMPT MAESTRO (v3.1 - CONTEXTO DEL MÓDULO 3) ---
$prompt = "Actúa como un copywriter experto en marketing de respuesta directa para el negocio local '{$data['business_name']}'.
Tu tarea es generar 3 anuncios para Facebook, cada uno con un enfoque psicológico distinto.

--- CONTEXTO Y FILOSOFÍA DEL CURSO (Módulo 3: Creando el Anuncio Estratégico) ---
La estructura de un buen anuncio se basa en 3 pasos:
1.  **GANCHO:** La primera línea debe atraer la atención. Debe ser una pregunta o afirmación que toque el problema o deseo del cliente ideal para que se sienta identificado de inmediato. (Ej: '¿Llegas cansado del trabajo y aún tienes que limpiar?').
2.  **SOLUCIÓN:** Explica brevemente qué ofreces, cómo ayudas y en qué zona trabajas. (Ej: 'Hacemos limpieza profesional en [zona]. Tú descansas, nosotros dejamos tu casa impecable.').
3.  **LLAMADO A LA ACCIÓN (CTA):** Dile al cliente exactamente qué debe hacer para contactarte. Debe ser directo y fácil. (Ej: 'Escríbenos ahora y agenda tu servicio.').

--- TU TAREA ESPECÍFICA ---
Genera 3 anuncios para Facebook, cada uno con un enfoque distinto:
1.  **Anuncio Enfocado en el Problema:** El 'gancho' debe agitar el problema del cliente. La 'solucion' debe presentar el servicio como el alivio a ese problema.
2.  **Anuncio Enfocado en el Deseo:** El 'gancho' debe pintar una imagen del resultado ideal. La 'solucion' debe mostrar cómo el servicio entrega ese deseo.
3.  **Anuncio Enfocado en el Servicio:** El 'gancho' debe ser una presentación directa y profesional. La 'solucion' debe listar beneficios con checkmarks (✅).

REGLAS DE FORMATO Y PERSONALIZACIÓN:
- Usa el nombre del negocio '{$data['business_name']}' en al menos uno de los anuncios.
- En la 'cta', SIEMPRE incluye el teléfono/WhatsApp: {$data['phone']}.
- Si el usuario proporciona una página web ({$data['website']}), inclúyela también en la 'cta'.
- La respuesta final DEBE ser un objeto JSON válido con una clave 'anuncios', que es un array de 3 objetos. Cada objeto debe tener 'titulo', 'es' (con gancho, solucion, cta), y 'en' (con gancho, solucion, cta).
- Usa los títulos exactos en español: '💡 ANUNCIO ENFOCADO EN EL PROBLEMA', '💡 ANUNCIO ENFOCADO EN EL DESEO', '💡 ANUNCIO ENFOCADO EN EL SERVICIO'.

--- DATOS DEL ESTUDIANTE ---
- Nombre del Negocio: {$data['business_name']}
- Teléfono/WhatsApp: {$data['phone']}
- Página Web: {$data['website']}
- Servicio: {$data['service']}
- Zona: {$data['zone']}
- Problema del Cliente: {$data['problem']}
- Deseo del Cliente: {$data['desire']}";


$apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . $apiKey;
$payload = ['contents' => [['parts' => [['text' => $prompt]]]], 'generationConfig' => ['response_mime_type' => 'application/json']];

$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($response === false || $http_code !== 200) {
    http_response_code(500);
    echo json_encode(['error' => 'No se pudo obtener una respuesta de la IA.', 'details' => $response]);
    exit;
}

$result = json_decode($response, true);
$generated_text = $result['candidates'][0]['content']['parts'][0]['text'];
$generated_text = str_replace(['```json', '```'], '', $generated_text);
$final_data = json_decode(trim($generated_text), true);

if ($final_data === null || !isset($final_data['anuncios'])) {
    http_response_code(500);
    echo json_encode(['error' => 'La IA devolvió un formato de JSON inválido.', 'raw_response' => $generated_text]);
    exit;
}

echo json_encode($final_data);
?>
